% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducible-package.R
\docType{package}
\name{reproducible-package}
\alias{reproducible}
\alias{reproducible-package}
\title{The \code{reproducible} package}
\description{
\lifecycle{maturing}

This package aims at making
high-level, robust, machine and OS independent tools for making deeply
reproducible and reusable content in R. The \code{Require} function is a
different take on package management, such as \pkg{renv}, \pkg{packrat} and
\pkg{checkpoint} that attempts to be more seamless. The package also includes
tools for caching, preparing data files and accessing GitHub repositories.
}
\section{Main Tools}{


There are many elements within the reproducible package.
However, there are currently three main ones that are critical for reproducible research.
The key element for reproducible research is that the code must always return the same content
every time it is run, but it must be vastly faster the 2nd, 3rd, 4th etc, time it is run.
That way, the entire code sequence for a project of arbitrary size can be run
\emph{from the start} every time.

\describe{
  \item{\code{Cache}:}{A robust wrapper for any function, including those with environments,
  disk-backed storage (currently on \code{Raster}) class), operating-system independent,
  whose first time called will execute the function, second time will compare the inputs to a
  database of entries, and recover the first result if inputs are identical.
  If \code{options("reproducible.useMemoise" = TRUE)}, the third time will be very fast as it
  will recover the answer from RAM.}
  \item{\code{prepInputs}:}{ Download, or load objects, and possibly post-process them.
  The main advantage to using this over more direct routes is that it will automatically build
  checksums tables, use \code{Cache} internally where helpful, and possibly run a variety of
  post-processing actions.
  This means this function can also itself be cached for even more speed.
  This allows all project data to be stored in custom cloud locations or in their original online
  data repositories, \code{without altering code} between the first, second, third, etc., times
  the code is run.}
  \item{\code{Require}:}{A version of \code{require} that incorporates elements of
  \code{install.packages}, \code{devtools::install_github}, \pkg{packrat}.
  It allows for users code to work for a new user on a new machine that may or may not have all
  packages installed.}
}
}

\section{Package options}{


See \code{\link{reproducibleOptions}} for a complete description of package
\code{\link{options}} to configure behaviour.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://reproducible.predictiveecology.org}
  \item \url{https://github.com/PredictiveEcology/reproducible}
  \item Report bugs at \url{https://github.com/PredictiveEcology/reproducible/issues}
}

}
\author{
\strong{Maintainer}: Eliot J B McIntire \email{eliot.mcintire@canada.ca} (\href{https://orcid.org/0000-0002-6914-8316}{ORCID})

Authors:
\itemize{
  \item Alex M Chubaty \email{alex.chubaty@gmail.com} (\href{https://orcid.org/0000-0001-7146-8135}{ORCID})
}

Other contributors:
\itemize{
  \item Tati Micheletti \email{tati.micheletti@gmail.com} (\href{https://orcid.org/0000-0003-4838-8342}{ORCID}) [contributor]
  \item Ceres Barros \email{cbarros@mail.ubc.ca} (\href{https://orcid.org/0000-0003-4036-977X}{ORCID}) [contributor]
  \item Ian Eddy \email{ian.eddy@canada.com} (\href{https://orcid.org/0000-0001-7397-2116}{ORCID}) [contributor]
  \item Her Majesty the Queen in Right of Canada, as represented by the Minister of Natural Resources Canada [copyright holder]
}

}
