% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{createCache}
\alias{createCache}
\alias{saveToCache}
\alias{loadFromCache}
\alias{rmFromCache}
\title{Create a new cache}
\usage{
createCache(
  cachePath,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL),
  force = FALSE
)

saveToCache(
  cachePath,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL),
  obj,
  userTags,
  cacheId
)

loadFromCache(cachePath, cacheId)

rmFromCache(
  cachePath,
  cacheId,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL)
)
}
\arguments{
\item{cachePath}{A path describing the directory in which to create
the database file(s)}

\item{drv}{A driver, passed to \code{dbConnect}}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{force}{Logical. Should it create a cache in the \code{cachePath},
  even if it already exists, overwriting.
# replaces archivist::createLocalRepo}

\item{obj}{The R object to save to the cache}

\item{userTags}{A character vector with descriptions of the Cache function call. These
will be added to the Cache so that this entry in the Cache can be found using
\code{userTags} e.g., via \code{\link{showCache}}}

\item{cacheId}{The hash string representing the result of \code{.robustDigest}}
}
\description{
Create a new cache

Low level tools to work with Cache
}
