% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{pkgDep}
\alias{pkgDep}
\alias{pkgDep2}
\title{Determine package dependencies, first looking at local filesystem}
\usage{
pkgDep(packages, libPath, recursive = TRUE, depends = TRUE,
  imports = TRUE, suggests = FALSE, linkingTo = TRUE,
  repos = getOption("repos"), refresh = FALSE,
  verbose = getOption("reproducible.verbose"))

pkgDep2(packages, recursive = TRUE, depends = TRUE, imports = TRUE,
  suggests = FALSE, linkingTo = TRUE, repos = getOption("repos"),
  refresh = FALSE, verbose = getOption("reproducible.verbose"),
  sorted = TRUE)
}
\arguments{
\item{packages}{a character vector of package names.}

\item{libPath}{The library path where all packages should be installed, and looked for to load
(i.e., call \code{library})}

\item{recursive}{Logical. Should dependencies of dependencies be searched, recursively.
NOTE: Dependencies of suggests will not be recursive. Default \code{TRUE}.}

\item{depends}{Logical. Include packages listed in "Depends". Default \code{TRUE}.}

\item{imports}{Logical. Include packages listed in "Imports". Default \code{TRUE}.}

\item{suggests}{Logical. Include packages listed in "Suggests". Default \code{FALSE}.}

\item{linkingTo}{Logical. Include packages listed in "LinkingTo". Default \code{TRUE}.}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to either
\code{install.packages}, \code{install_github} or \code{installVersions}.}

\item{refresh}{There is an internal type of caching. If the results are wrong, likely
set \code{refresh = TRUE}.}

\item{verbose}{logical indicating if output should monitor the package
    search cycles.}

\item{sorted}{Logical. If \code{TRUE}, the default, the packages will be sorted in
the returned list from most number of dependencies to least.}
}
\description{
This is intended to replace \code{\link[tools]{package_dependencies}} or
\code{pkgDep} in the \pkg{miniCRAN} package, but with modifications for speed.
It will first check local package directories in \code{libPath}, and it if
the function cannot find the packages there, then it will use
\code{\link[tools]{package_dependencies}}.

\code{pkgDep2} is a convenience wrapper of \code{pkgDep} that
"goes one level in" i.e., the first order dependencies, and runs
the \code{pkgDep} on those.
}
\note{
\code{package_dependencies} and \code{pkgDep} will differ under the following
circumstances:
\enumerate{
  \item GitHub packages are not detected using \code{tools::package_dependencies};
  \item \code{tools::package_dependencies} does not detect the dependencies of base packages
    among themselves, \emph{e.g.}, \code{methods} depends on \code{stats} and \code{graphics}.
}
}
\examples{
pkgDep("crayon")
pkgDep2("reproducible")
}
