% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calcPHatConfidenceIntervals}
\alias{calcPHatConfidenceIntervals}
\title{calcPHatConfidenceIntervals}
\usage{
calcPHatConfidenceIntervals(
  phat,
  phat.variance,
  phat.df,
  alpha = 0.05,
  alternative = "two.sided"
)
}
\arguments{
\item{phat}{This is the value of the probability of superiority.}

\item{phat.variance}{This is the estimated variance of the probability of superiority.}

\item{phat.df}{The degrees of freedom associated with phat value.}

\item{alpha}{This is the alpha level required for the statistical tests
(default 0.05)}

\item{alternative}{This defines whether a one-sided test or a two-sided
(i.e. default) test is required. For a one-sided test use parameter values
greater' or 'less' to define whether the phat-value should be greater or
less than 0.5.}
}
\value{
The function returns a Boolean variable identifying whether the effect size is significant and the confidence interval bounds.
}
\description{
This functions is a helper function. It assesses the significance one-sided and two-sided statistical of the probability of superiority based on its confidence interval. The type of test and the direction of the test is determined by the parameter alternative which takes one of the values 'two.sided', 'greater' or 'less'.
}
\examples{
reproducer:::calcPHatConfidenceIntervals(.65,0.005,8)
# A tibble: 1 x 5
#  phat.test pvalue phat.sig phat.ci.lower phat.ci.upper
#     <dbl>  <dbl> <lgl>            <dbl>         <dbl>
# 1      2.12 0.0667 FALSE            0.487         0.813
reproducer:::calcPHatConfidenceIntervals(.65,0.005,8,alternative='greater')
# A tibble: 1 x 5
#  phat.test pvalue phat.sig phat.ci.lower phat.ci.upper
#      <dbl>  <dbl> <lgl>            <dbl>         <dbl>
# 1      2.12 0.0333 TRUE             0.519             1
}
\author{
Barbara Kitchenham and Lech Madeyski
}
