% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculate2GMdMRE}
\alias{calculate2GMdMRE}
\title{calculate2GMdMRE}
\usage{
calculate2GMdMRE(
  mean = 0,
  sd = 1,
  N,
  reps,
  diff = c(0.2, 0.5, 0.8),
  type = "n",
  seed = 123,
  StdAdj = 0,
  AlwaysTwoSidedTests = FALSE,
  LargeSampleSize = 5e+06
)
}
\arguments{
\item{mean}{The mean (or rate for gamma data) of the baseline distribution}

\item{sd}{The standard deviation or shape of the baseline distribution}

\item{N}{The nuber of obervations per group in each of the simulated experiment}

\item{reps}{The number of  experiments  (i.e. two-group datasets) to be simulated}

\item{diff}{A list identifying the mean group differences being assessed}

\item{type}{A string parameter defining the distribution being simulated i.e. 'n' for normal data, 'l' for log-normal data, 'g' for gamma data and 'lap' for LaPlace data.}

\item{seed}{A starting value for the simulations}

\item{StdAdj}{A value that can be used to add additional variance for normal, lognormal and Laplce data and to change the shape parameter for gamma data.}

\item{AlwaysTwoSidedTests}{A boolean variable. If TRUE the simulation always used two-sided tests otherwise the simulations use one-sided tests.}

\item{LargeSampleSize}{Size of the large sample (default 5000000) used in
each of the two groups used to obtain expected values of the non-parametric
effect sizes (the expected value of the standardized men difference are
always known)}
}
\value{
Tibble identifying the accuracy i.e. MdMRE of three effect sizes Cliff's d, PHat, and StdMD estimates found in each sample, the variance of each of effect sizes, the mean of the observed values, the expected values of the effect sizes based on a single large sample and the power of each effect size based on the proportion of samples for which the effect sizes were significant.
}
\description{
The function uses simulations assess the accuracy and power of parametric and non-parametric effect sizes for two group designs and four different distributions.
}
\examples{
as.data.frame(
  calculate2GMdMRE(
    mean=0, sd=1, N=10, reps=20, diff=c(0.2,0.5,0.8), type='n', seed=123,
    StdAdj = 0, AlwaysTwoSidedTests=FALSE, LargeSampleSize=10000))
# Design Obs Diff CliffdMdMRE  PHatMdMRE StdESMdMRE  varCliffd     varPHat
# 1   2G_n  20  0.2   1.8866607 0.18083062  1.3757827 0.06089579 0.015223947
# 2   2G_n  20  0.5   0.5956595 0.12644453  0.5295375 0.04872737 0.012181842
# 3   2G_n  20  0.8   0.3077882 0.09139686  0.3698596 0.03492526 0.008731316
# StdESVar ObsCliffd ObsPHat  ObsStdES CliffdExpected PHatExpected
# 1 0.1666288     0.127  0.5635 0.2267731      0.1060074    0.5530037
# 2 0.1804443     0.283  0.6415 0.5386875      0.2694811    0.6347405
# 3 0.1978285     0.429  0.7145 0.8506020      0.4223684    0.7111842
# StdESExpected CliffdPower PHatPower StdESPower
# 1     0.1866728        0.10      0.10        0.1
# 2     0.4884736        0.15      0.15        0.2
# 3     0.7882317        0.50      0.50        0.6
#as.data.frame(
#  calculate2GMdMRE(
#   mean=0, sd=1, N=10, reps=100, diff=c(0.2,0.5,0.8), type='n', seed=123,
#   StdAdj = 0, AlwaysTwoSidedTests=FALSE, LargeSampleSize=10000))
#  Design Obs Diff CliffdMdMRE PHatMdMRE StdESMdMRE  varCliffd    varPHat  StdESVar ObsCliffd
#1   2G_n  20  0.2   1.9702583 0.1840919  1.7111237 0.07552663 0.01888166 0.2522504    0.1092
#2   2G_n  20  0.5   0.6428482 0.1358012  0.6357666 0.06842711 0.01710678 0.2624379    0.2646
#3   2G_n  20  0.8   0.4036555 0.1196213  0.4063333 0.05873046 0.01468262 0.2787054    0.4078
#  ObsPHat  ObsStdES CliffdExpected PHatExpected StdESExpected CliffdPower PHatPower StdESPower
#1  0.5546 0.1835910      0.1030653    0.5515327     0.1870328        0.09      0.12       0.10
#2  0.6323 0.4949159      0.2678275    0.6339138     0.4869850        0.18      0.22       0.24
#3  0.7039 0.8062407      0.4211512    0.7105756     0.7869372        0.44      0.52       0.56

}
\author{
Barbara Kitchenham and Lech Madeyski
}
