% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{NP2GroupMetaAnalysisSimulation}
\alias{NP2GroupMetaAnalysisSimulation}
\title{NP2GroupMetaAnalysisSimulation}
\usage{
NP2GroupMetaAnalysisSimulation(
  mean,
  sd,
  diff,
  GroupSize,
  Exp = 5,
  type = "n",
  StdAdj = 0,
  alpha = 0.05,
  seed = 123,
  StdExp = 0,
  MAMethod,
  returnES = FALSE
)
}
\arguments{
\item{mean}{the value used for the mean of control group in the simulated data. It can be any real number including zero.}

\item{sd}{the value used for the spread of the control group and the spread of the treatment group in the simulated data. The value must be a real value greater than 0.}

\item{diff}{mean+diff is the value used for the mean of the treatment group. It can be zero.}

\item{GroupSize}{is the size of each of the 2 groups comprising one experiment. GroupSize should be an integer of 4 or more}

\item{Exp}{is the number of experiments being simulated. Exp should be an integer of 2 or more. It defaults to 5.}

\item{type}{specifies the distribution being simulated. The permited values are "n" for the normal distribution,  "l" for the lognormal distribution, "g" for the gamma distribution and "lap" for the Laplace distribution. The parameter defaults to "n".}

\item{StdAdj}{specifies a level used to adjust the treatment variance. It allows heterogeneity to be modelled. It defaults to zero meaning no variance heterogeneity is introduced.}

\item{alpha}{the Type 1 error rate level use for statistical tests itb defaults to 0.05.}

\item{seed}{specifies the seed to be used to initiate the simulation, so the simulation is repeatable. It defauls to 123.}

\item{StdExp}{specifies the adjustment made to the variance of each experiment, if it is required to simulate variance heterogeneity due to individual experiments in a family. It defaults to 0.}

\item{MAMethod}{the meta-analysis method needed for the call to the metafor package rma algorithm}

\item{returnES}{Determines the format of the output. It defaults to FALSE which causes the function to output the meta-anaysis results for the family of experiments. If set to TRUE it returns the effect sizes for each experiment.}
}
\value{
Depending on the value of the returnES parameter, the function either returnd the effect sizes for each experiment or the aggregated resutls for the family
}
\description{
This function simulates data from a family of experiments. The parameter Exp deteremines the number of experiments in the family. The function simulates data from one of four distributions and uses the data to construct two of groups of equal size (GroupSize). The distribution for one  of the groups corresponds to the control and is based on the given mean and spread, the distribution for the other group corresponds to the treatment group and  is based on the mean+diff and the spread plus any variance adjusemtn (determined by the parametrt StdAdj). The data from each experiment is analysed separately to estimate three non-parametric effect sizes: the point bi-serial version of Kendall's tau, Cliff's d and the probability of superiority referred to as phat and their variances. Parametric effect sizes Cohen's d (also known as the standarized means difference, SMD) and the small sample size adjusted standardized mean difference g are also calculated to gether with their variances. The effect sizes are then meta-analysed using two main methods: the simple avarge of the effect size and the variance weighted average. The function uses the metafor package for formal meta-analysis, and the specific method of formal meta-analysis used is determined by the MAAMethod. All tests of signficance are done at the 0.05 level. If the parameter returnES is TRUE, the function returns it returns the effect sizes for each experiment in the family, otherwise it returns the meta-analysis results.
}
\examples{
NP2GroupMetaAnalysisSimulation(mean=0,sd=1,diff=0.5,GroupSize=100,Exp=5,type="n",StdAdj=0,
alpha=0.05,seed=123,StdExp=1,MAMethod="PM",returnES=FALSE)
# A tibble: 1 x 30
#  NumExp GroupSize AveKtau AveKtauctvar tauSigCVt AveCliffd AveCliffdvar AveCliffdsig Avephat
#  Avephatvar Avephatsig
#   <dbl>     <dbl>   <dbl>        <dbl> <lgl>         <dbl>        <dbl> <lgl>          <dbl>
#  <dbl> <lgl>
# 1      5       100   0.126     0.000315 TRUE          0.250      0.00125 TRUE           0.625
# 0.000310 TRUE
# … with 19 more variables: MAMean <dbl>, MAvar <dbl>, MASig <lgl>, QE <dbl>, QEp <dbl>,
# HetSig <lgl>, P.mean <dbl>,
NP2GroupMetaAnalysisSimulation(mean=0,sd=1,diff=0.5,GroupSize=10,Exp=5,type="n",StdAdj=0,
alpha=0.05,seed=123,StdExp=1,MAMethod="PM",returnES=TRUE)
# A tibble: 5 x 17
# MeanExp VarExp StdESExp    df    tval  tpval   tciL   tciU Cliffd Cliffdvar  PHat PHatvar
# PHatdf       g gvar.exact
#    <dbl>  <dbl>    <dbl> <dbl>   <dbl>  <dbl>  <dbl>  <dbl>  <dbl>     <dbl> <dbl>   <dbl>
# <dbl>   <dbl> <lgl>
#1  0.226   1.03    0.223   17.9 -0.498  0.624  -1.18   0.728   0.1     0.0808  0.55 0.0197
# 17.8  0.213  NA
#2  1.00    0.622   1.27    15.4 -2.84   0.0122 -1.75  -0.251   0.64    0.0400  0.82 0.00947
# 15.0  1.21   NA
#3  0.432   0.848   0.469   18.0 -1.05   0.308  -1.30   0.434   0.36    0.0725  0.68 0.0177
# 15.5  0.449  NA
#4  0.434   0.967   0.441   13.7 -0.986  0.341  -1.38   0.512   0.22    0.0759  0.61 0.0184
# 14.6  0.416  NA
#5 -0.0342  0.782  -0.0387  14.9  0.0865 0.932  -0.809  0.878  -0.2     0.0817  0.4  0.02
# 17.3 -0.0367 NA
# … with 2 more variables: gvar.approx <dbl>, ...17 <dbl>
NP2GroupMetaAnalysisSimulation(mean=0,sd=1,diff=0.724,GroupSize=10,Exp=5,type="l",StdAdj=0,
alpha=0.05,seed=123,StdExp=1,MAMethod="PM",returnES=FALSE)
# A tibble: 1 x 30
#  NumExp GroupSize AveKtau AveKtauctvar tauSigCVt AveCliffd AveCliffdvar AveCliffdsig Avephat
# Avephatvar Avephatsig
#   <dbl>     <dbl>   <dbl>        <dbl> <lgl>         <dbl>        <dbl> <lgl>          <dbl>
# <dbl> <lgl>
# 1      5        10   0.181      0.00360 TRUE          0.344       0.0129 TRUE           0.672
# 0.00312 TRUE
# … with 19 more variables: MAMean <dbl>, MAvar <dbl>, MASig <lgl>, QE <dbl>, QEp <dbl>,
# HetSig <lgl>, P.mean <dbl>,
#   P.rsig <lgl>, P.hetsig <lgl>, Mean.phat <dbl>, phat.sig <lgl>, Mean.d <dbl>, d.sig <lgl>,
# Mean.g.exact <dbl>,
#   g.exact.sig <lgl>, Mean.g.approx <dbl>, g.approx.sig <lgl>, Cohend.mean <dbl>,
# Cohend.sig <lgl>
}
\author{
Barbara Kitchenham and Lech Madeyski
}
