% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MadeyskiKitchenhamMetaAnalysis.R
\name{effectSizeCI}
\alias{effectSizeCI}
\title{effectSizeCI}
\usage{
effectSizeCI(epsilon = 1e-10, maxsteps = 100, stepsize = 3, t, n1, n2, r)
}
\arguments{
\item{epsilon}{The precision used to caculate the probability that a value from the non-central t distribution is less than t_LB etc.}

\item{maxsteps}{The maximum number of steps of the iterative procedure (the procedure terminates at maxsteps or earlier if enough CI with enough precision have been calculated)}

\item{stepsize}{The size of steps (influences the convergence of the calculations, i.e., the number of steps required to obtain the final result of precison defined by the epsilon)}

\item{t}{t-statistics}

\item{n1}{The number of observations in sequence group 1}

\item{n2}{The number of observations in sequence group 2}

\item{r}{The correlation between outcomes for individual subject (the within subject correlation)}
}
\value{
A list of Confidence Intervals for: t-statistic (t_LB and t_UB), repeted-measures effect size d_RM (d_RM_LB, d_RM_UB), independent groups effect size (d_IG_LB, d_IG_UB)
}
\description{
95% Confidence Intervals (CI) on Standardised Effect Sizes (d) for cross-over repeated-measures designs
The procedure is based on finding the upper and lower 0.025 bounds for the related t-variable.
The upper and lower bounds on the t-variable are then used to calculate to upper and lower bounds on the
repeated measures effect size (d_RM) by multiplying the upper and lower bound of the t-variable by sqrt((n1+n2)/(2*(n1*n2))).
Upper and lower bounds on the equivalent independent groups effect size (d_IG) are found by multiplying the upper and lower
bounds on d_RM by sqrt(1-r).
}
\examples{
effectSizeCI(t=14.4, n1=15, n2=15, r=0.6401)
}
\author{
Lech Madeyski and Barbara Kitchenham
}

