% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/represent.R
\name{represent}
\alias{represent}
\title{Create a representative dataset post record-linkage.}
\usage{
represent(
  data,
  linkage,
  rep_method,
  parallel = TRUE,
  cores = NULL,
  ...,
  scale = FALSE
)
}
\arguments{
\item{data}{A data frame of records to be represented.}

\item{linkage}{A numeric vector indicating the cluster ids post-record linkage for each record in \code{data}.}

\item{rep_method}{Which method to use for representation. Valid options include "proto_minimax", "proto_random",
and "composite".}

\item{parallel}{Logical flag if to use parallel computation or not (via \code{foreach}).}

\item{cores}{If specified, the number of cores to use with \code{foreach}.}

\item{...}{Additional parameters sent to cluster representation function. See
\link[=clust_proto_minimax]{prototyping} or \link[=clust_composite]{composite} methods.}

\item{scale}{If "proto_minimax" method is specified, logical flag to indicate if the column-type
distance function should be scaled so that each distance takes value in [0, 1]. Defaults to
FALSE.}
}
\description{
Create a representative dataset post record-linkage.
}
\examples{

data("rl_reg1")

## random prototyping
rep_dat_random <- represent(rl_reg1, identity.rl_reg1, "proto_random", id = FALSE, parallel = FALSE)
head(rep_dat_random)

## minimax prototyping
col_type <- c("string", "string", "numeric", "numeric", "numeric", "categorical", "ordinal",
    "numeric", "numeric")
orders <- list(education = c("Less than a high school diploma", "High school graduates, no college",
    "Some college or associate degree", "Bachelor's degree only", "Advanced degree"))
weights <- c(.25, .25, .05, .05, .1, .15, .05, .05, .05)
rep_dat_minimax <- represent(rl_reg1, identity.rl_reg1, "proto_minimax", id = FALSE,
    distance = dist_col_type, col_type = col_type, weights = weights, orders = orders,
    scale = TRUE, parallel = FALSE)
head(rep_dat_minimax)

## composite prototyping
rep_dat_composite <- represent(rl_reg1, identity.rl_reg1, "composite",
                               col_type = col_type, parallel = FALSE)
head(rep_dat_composite)

}
