% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{forestplotUV}
\alias{forestplotUV}
\title{Create an univariable forest plot using ggplot2}
\usage{
forestplotUV(
  response,
  covs,
  data,
  id = NULL,
  corstr = NULL,
  model = "glm",
  family = NULL,
  digits = getOption("reportRmd.digits", 2),
  conf.level = 0.95,
  orderByRisk = TRUE,
  colours = "default",
  showEst = TRUE,
  rmRef = FALSE,
  logScale = getOption("reportRmd.logScale", TRUE),
  nxTicks = 5,
  showN = TRUE,
  showEvent = TRUE
)
}
\arguments{
\item{response}{character vector with names of columns to use for response}

\item{covs}{character vector with names of columns to use for covariates}

\item{data}{dataframe containing your data}

\item{id}{character vector which identifies clusters. Only used for geeglm}

\item{corstr}{character string specifying the correlation structure. Only
used for geeglm. The following are permitted: '"independence"',
'"exchangeable"', '"ar1"', '"unstructured"' and '"userdefined"'}

\item{model}{fitted model object}

\item{family}{description of the error distribution and link function to be
used in the model. Only used for geeglm}

\item{digits}{number of digits to round to}

\item{conf.level}{controls the width of the confidence interval}

\item{orderByRisk}{logical, should the plot be ordered by risk}

\item{colours}{can specify colours for risks less than, 1 and greater than
1.0. Default is red, black, green}

\item{showEst}{logical, should the risks be displayed on the plot in text}

\item{rmRef}{logical, should the reference levels be removed for the plot?}

\item{logScale}{logical, should OR/RR be shown on log scale, defaults to
TRUE, or reportRmd.logScale if set. See https://doi.org/10.1093/aje/kwr156 for why you may prefer a
linear scale.}

\item{nxTicks}{Number of tick marks supplied to the log_breaks function to
produce}

\item{showN}{Show number of observations per variable and category}

\item{showEvent}{Show number of events per variable and category}
}
\value{
a plot object
}
\description{
This function will send and take log or logistic regression fit from glm or geeglm
from uvsum function, and display the OR or RR for each variable on the appropriate log scale.
}
\examples{
data("pembrolizumab")
forestplotUV(response="orr", covs=c("change_ctdna_group", "sex", "age", "l_size"),
data=pembrolizumab, family='binomial')
}
\keyword{plot}
