% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{outTable}
\alias{outTable}
\title{Print tables to PDF/Latex HTML or Word}
\usage{
outTable(
  tab,
  row.names = NULL,
  to_indent = numeric(0),
  bold_headers = TRUE,
  rows_bold = numeric(0),
  bold_cells = NULL,
  caption = NULL,
  digits,
  align,
  applyAttributes = TRUE,
  keep.rownames = FALSE,
  fontsize,
  chunk_label
)
}
\arguments{
\item{tab}{a table to format}

\item{row.names}{a string specifying the column name to assign to the
rownames. If NULL (the default) then rownames are removed.}

\item{to_indent}{numeric vector indicating which rows to indent in the first
column.}

\item{bold_headers}{boolean indicating if the column headers should be
bolded}

\item{rows_bold}{numeric vector indicating which rows to bold}

\item{bold_cells}{array indices indicating which cells to bold. These will be
in addition to rows bolded by rows_bold.}

\item{caption}{table caption}

\item{digits}{number of digits to round numeric columns to, wither a single
number or a vector corresponding to the number of numeric columns in tab}

\item{align}{string specifying column alignment, defaults to left alignment
of the first column and right alignment of all other columns. The align
argument accepts a single string with 'l' for left, 'c' for centre and 'r'
for right, with no separations. For example, to set the left column to be
centred, the middle column right-aligned and the right column left aligned
use: align='crl'}

\item{applyAttributes}{boolean indicating if the function should use
to_indent and bold_cells formatting attributes. This will only work
properly if the dimensions of the table output from rm_covsum, rm_uvsum etc
haven't changed.}

\item{keep.rownames}{should the row names be included in the output}

\item{fontsize}{PDF/HTML output only, manually set the table fontsize}

\item{chunk_label}{only used knitting to Word docs to allow cross-referencing}
}
\value{
A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
Output the table nicely to whatever format is appropriate. This is the output
function used by the rm_* printing functions.
}
\details{
Entire rows can be bolded, or specific cells. Currently indentation refers to
the first column only. By default, underscores in column names are converted
to spaces. To disable this set rm_ to FALSE
}
\examples{
# To make custom changes or change the fontsize in PDF/HTML
tab <- rm_covsum(data=pembrolizumab,maincov = 'change_ctdna_group',
covs=c('age','sex','pdl1','tmb','l_size'),show.tests=TRUE,tableOnly = TRUE)
outTable(tab, fontsize=7)

# To bold columns with the variable names
 rows_bold <- c(1,4,7,10,13)
 outTable(tab,rows_bold = rows_bold)

 # To bold the estimates for male/female
 bold_cells <- as.matrix(expand.grid(5:6,1:ncol(tab)))
 outTable(tab,bold_cells= bold_cells)
}
