% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_build}
\alias{repo_build}
\title{Builds a resource using the associated code chunk}
\usage{
repo_build(name, src = NULL, recursive = T, force = F,
  env = parent.frame(), built = list())
}
\arguments{
\item{name}{Name of an item in the repo.}

\item{src}{Path to a source file containing the code block
associated with the resource. Not necessary if \code{name} is
already in the repository and has an associated source item.}

\item{recursive}{Build dependencies not already in the repo
recursively (T by default).}

\item{force}{Re-build dependencies recursively even if already in
the repo (F by default).}

\item{env}{Environment in which to run the code chunk associated
with the item to build. Parent environment by default.}

\item{built}{A list of items already built used for recursion (not
meant to be passed directly).}
}
\value{
Nothing, used for side effects.
}
\description{
In order to be \code{build}able, a repository item must have an
associated source file and code chunk.
}
\details{
Code chunks are defined as in the following example: ```
## chunk "item 1" {
        x <- code_to_make_x()
        rp$put(x, "item 1")
## }
```

`item 1` must be associated to the source (`src` parameter of
`put`) containing the chunk code.
}
