% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{replyr_summary}
\alias{replyr_summary}
\title{Compute usable summary of columns of tbl.}
\usage{
replyr_summary(x, ..., countUniqueNum = FALSE, countUniqueNonNum = FALSE,
  cols = NULL, tempNameGenerator = makeTempNameGenerator("replyr_summary"))
}
\arguments{
\item{x}{tbl or item that can be coerced into such.}

\item{...}{force additional arguments to be bound by name.}

\item{countUniqueNum}{logical, if true include unique non-NA counts for numeric cols.}

\item{countUniqueNonNum}{logical, if true include unique non-NA counts for non-numeric cols.}

\item{cols}{if not NULL set of columns to restrict to.}

\item{tempNameGenerator}{temp name generator produced by replyr::makeTempNameGenerator, used to record dplyr::compute() effects.}
}
\value{
summary of columns.
}
\description{
Compute usable summary of columns of tbl.
}
\examples{

d <- data.frame(x=c(NA,2,3),y=factor(c(3,5,NA)),z=c('a',NA,'z'),
                stringsAsFactors=FALSE)
replyr_summary(d)

}
