% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use-python.R
\name{use_python}
\alias{use_python}
\title{Use Python}
\usage{
use_python(
  python = NULL,
  ...,
  type = c("auto", "virtualenv", "conda", "system"),
  name = NULL,
  project = NULL
)
}
\arguments{
\item{python}{The path to a Python binary. This can be the path to a Python
binary on the system, or the path to a Python binary within an
already-existing Python environment. If \code{NULL}, the \code{RETICULATE_PYTHON}
environment variable is checked; if that is not set, then the default
version of \code{python} on the \code{PATH} is used instead. As a special case,
\code{use_python(FALSE)} can be used to deactivate Python integration with
a project.}

\item{...}{Optional arguments; currently unused.}

\item{type}{The type of Python environment to use. When \code{"auto"} (the
default), a project-local environment (virtual environments on Linux /
macOS; conda environments on Windows) will be created. Ignored if the
requested version of \code{python} lives within a pre-existing Python
environment.}

\item{name}{The name or path that should be used for the associated Python
environment. If \code{NULL} and \code{python} points to a Python executable living
within a pre-existing virtual environment, that environment will be used.
Otherwise, a project-local environment will be created instead.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
\code{TRUE}, indicating that the requested version of Python has been
successfully activated. Note that this function is normally called for
its side effects.
}
\description{
Associate a version of Python with your project.
}
\details{
When Python integration is active, \code{renv} will:
\itemize{
\item Save metadata about the requested version of Python in \code{renv.lock} -- in
particular, the Python version, and the Python type ("virtualenv", "conda",
"system"),
\item On load, set the \code{RETICULATE_PYTHON} environment variable, so that the
\code{reticulate} package can automatically use the requested copy of Python
as appropriate,
\item Capture the set of installed Python packages during \code{renv::snapshot()},
\item Reinstall the set of recorded Python packages during \code{renv::restore()}.
}
}
\examples{
\dontrun{

# use python with a project
renv::use_python()

# use virtualenv python with a project
renv::use_python(type = "virtualenv")

# use conda python with a project
renv::use_python(type = "conda")

}
}
