% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\alias{format_p}
\alias{format_r}
\alias{format_d}
\title{Easily format p or r values}
\usage{
format_value(value, type = "d", ...)

format_p(
  p,
  precision = 0.001,
  prefix = NULL,
  suffix = NULL,
  sign = FALSE,
  stars = FALSE
)

format_r(r, precision = 0.01)

format_d(d, precision = 0.01)
}
\arguments{
\item{value}{Value to be formatted, when using the generic \code{\link[=format_value]{format_value()}}.}

\item{type}{Specify r or p value.}

\item{...}{To specify precision level, if necessary, when using the
generic \code{\link[=format_value]{format_value()}}. Simply add the \code{precision} argument.}

\item{p}{p value to format.}

\item{precision}{Level of precision desired, if necessary.}

\item{prefix}{To add a prefix before the value.}

\item{suffix}{To add a suffix after the value.}

\item{sign}{Logical. Whether to add an equal sign for p values higher or
equal to .001.}

\item{stars}{Logical. Whether to add asterisks for significant p values.}

\item{r}{r value to format.}

\item{d}{d value to format.}
}
\value{
A formatted p, r, or d value.
}
\description{
Easily format p or r values. Note: converts to character class
for use in figures or manuscripts to accommodate e.g., "< .001".
}
\details{
For the \emph{easystats} equivalent, see:
\code{\link[insight:format_value]{insight::format_value()}}.
}
\examples{
format_value(0.00041231, "p")
format_value(0.00041231, "r")
format_value(1.341231, "d")
format_p(0.0041231)
format_p(0.00041231)
format_r(0.41231)
format_r(0.041231)
format_d(1.341231)
format_d(0.341231)
}
\keyword{correlation}
\keyword{formatting}
\keyword{p}
\keyword{r}
\keyword{value}
