% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{as.reliabilitydiag}
\alias{as.reliabilitydiag}
\alias{is.reliabilitydiag}
\alias{as.reliabilitydiag.reliabilitydiag}
\alias{as.reliabilitydiag.default}
\alias{as.reliabilitydiag.data.frame}
\title{Coerce to a reliability diagram}
\usage{
as.reliabilitydiag(x, ...)

is.reliabilitydiag(x)

\method{as.reliabilitydiag}{reliabilitydiag}(x, y = NULL, r = NULL, tol = sqrt(.Machine$double.eps), ...)

\method{as.reliabilitydiag}{default}(
  x,
  y = NULL,
  r = NULL,
  xtype = NULL,
  xvalues = NULL,
  .name_repair = "unique",
  region.level = 0.9,
  region.method = NULL,
  region.position = "diagonal",
  n.boot = 100,
  ...
)

\method{as.reliabilitydiag}{data.frame}(
  x,
  y = NULL,
  r = NULL,
  xtype = NULL,
  xvalues = NULL,
  .name_repair = "unique",
  region.level = 0.9,
  region.method = NULL,
  region.position = "diagonal",
  n.boot = 100,
  ...
)
}
\arguments{
\item{x}{an \R object with probability predictions taking values in [0, 1];
usually a numeric vector or a list/data.frame containing numeric vectors.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector of binary response values in \{0, 1\} to be
predicted.}

\item{r}{an object inheriting from the class \code{'reliabilitydiag'};
alternative to \code{y}.}

\item{tol}{accuracy when comparing \code{y} in \code{'reliabilitydiag'}
objects.}

\item{xtype}{a string specifying whether the prediction values should be
treated as \code{"continuous"} or \code{"discrete"}.}

\item{xvalues}{a numeric vector of possible prediction values;
values in \code{x} are rounded to the nearest value in \code{xvalues} and
\code{xtype} is set to \code{"discrete"}.}

\item{.name_repair}{This argument is passed on as \code{repair} to
\code{\link[vctrs]{vec_as_names}}. See there for more details.}

\item{region.level}{a value in (0, 1) specifying the level at which
consistency or confidence regions are calculated.}

\item{region.method}{a string specifying whether \code{"resampling"},
\code{"continuous_asymptotics"}, or \code{"discrete_asymptotics"} are used
to calculate consistency/confidence regions.}

\item{region.position}{a string specifying whether consistency regions
around the \code{"diagonal"} or confidence regions around the
\code{"estimate"} are calculated.}

\item{n.boot}{the number of bootstrap samples when
\code{region.method == "resampling"}.}
}
\value{
\code{as.reliabilitydiag} returns a \code{'reliabilitydiag'} object.

 \code{is.reliabilitydiag} returns \code{TRUE} if its argument is a
 reliability diagram, that is, has \code{"reliabilitydiag"} among its classes,
 and \code{FALSE} otherwise.
}
\description{
Coerce numeric vectors, data frames, or anything else that can be coerced
by \code{as.data.frame} to a data frame of prediction values, into
an object inheriting from the \code{'reliabilitydiag'} class.
}
\seealso{
\code{\link{reliabilitydiag}}
}
