% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ines2rsb.R
\name{ines2rsb}
\alias{ines2rsb}
\title{Compute Rsb}
\usage{
ines2rsb(
  scan_pop1,
  scan_pop2,
  popname1 = NA,
  popname2 = NA,
  min_nhaplo = NA,
  standardize = TRUE,
  include_freq = FALSE,
  p.side = NA,
  p.adjust.method = "none",
  verbose = TRUE
)
}
\arguments{
\item{scan_pop1}{a data frame with markers in rows and columns with chromosome name, position of the
marker, frequency of the ancestral allele and inES as obtained by \code{\link{scan_hh}} on the first population.}

\item{scan_pop2}{a data frame with markers in rows and columns with chromosome name, position of the
marker, frequency of the ancestral allele and inES as obtained by \code{\link{scan_hh}} on the second population.}

\item{popname1}{short ID/name of the first population; to be added to an output column name.}

\item{popname2}{short ID/name of the second population; to be added to an output column name.}

\item{min_nhaplo}{discard positions where in at least one of the populations fewer than \code{min_nhaplo} haplotypes
have been evaluated (default \code{NA}).}

\item{standardize}{logical. If \code{TRUE} (default), then standardize Rsb, else report unstandardized Rsb.}

\item{include_freq}{logical. If \code{TRUE} include columns with allele frequencies into result.}

\item{p.side}{side to which refers the p-value. Default \code{NA}, meaning two-sided. Can be set
to \code{"left"} or \code{"right"}.}

\item{p.adjust.method}{method passed to function \code{\link[stats]{p.adjust}} to correct the p-value for
multiple testing. Default \code{"none"}.}

\item{verbose}{logical. If \code{TRUE} (default), report number of markers of the two source data frames and result data frame.}
}
\value{
The returned value is a data frame with markers in rows and columns for chromosome name, marker position,
Rsb and, if standardized, p-value in a negative log10 scale. Optionally, allele frequencies are included.
}
\description{
Compute Rsb (standardized ratio of inES of two populations).
}
\details{
Log ratio of inES (population 1 over population 2) computed as described in Tang et al. (2007).
Note that the two data frames are merged on the basis of chromosome and position. Marker names
are kept, if they are identical and unique in both data frames.

Since the standardized Rsb values follow, if markers evolve predominantly neutrally, approximately
a standard Gaussian distribution, it is practical to assign to the values a p-value relative
to the null-hypothesis of neutral evolution. The parameter \code{p.side} determines
if the p-value is assigned to both sides of the distribution or to one side of interest.
}
\examples{
library(rehh.data)
data(wgscan.cgu) ; data(wgscan.eut)
## results from a genome scan (44,057 SNPs)
##see ?wgscan.eut and ?wgscan.cgu for details
wgscan.rsb <- ines2rsb(wgscan.cgu, wgscan.eut, "CGU", "EUT")
}
\references{
Gautier, M. and Naves, M. (2011). Footprints of selection in the ancestral admixture of a New World Creole cattle breed. \emph{Molecular Ecology}, \strong{20}, 3128-3143.

Tang, K. and Thornton, K.R. and Stoneking, M. (2007). A New Approach for Using Genome Scans to Detect Recent Positive Selection in the Human Genome. \emph{Plos Biology}, \strong{7}, e171.
}
\seealso{
\code{\link{scan_hh}}, \code{\link{distribplot}}, \code{\link{manhattanplot}}
}
