% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_tools.R
\name{render_table_data}
\alias{render_table_data}
\title{render_table_data}
\usage{
render_table_data(
  data,
  editable = TRUE,
  dom = "frtip",
  pageLength = 10,
  scrollY = "27vh",
  server = T
)
}
\arguments{
\item{data}{a data.frame to create a the table.}

\item{editable}{whether to make an editable table. The default value is TRUE.}

\item{dom}{define the table control elements to appear on the page and in what order.}

\item{pageLength}{the number of rows to show. The default value is 10.}

\item{scrollY}{the heigth of the table.}

\item{server}{whether to use server-side processing. If TRUE, then the data is kept on the server and the browser requests a page at a time; if FALSE, then the entire data frame is sent to the browser at once.}
}
\value{
a shiny.render.function
}
\description{
create a table for the shiny application and render it.
}
\examples{
if(interactive()) {
   library(shiny)
   library(DT)
   shinyApp(
      ui = fluidPage(fluidRow(column(12, DTOutput('tbl')))),
      server = function(input, output) {
         output$tbl = render_table_data(iris)
      }
   )
}

}
\seealso{
\code{\link[DT]{datatable}}, \code{\link[DT]{renderDT}}
}
