% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_regions.R
\name{sig_regions}
\alias{sig_regions}
\title{Regions of significance for an interaction.}
\usage{
sig_regions(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm'.}

\item{...}{Additional arguments to be passed to the particular method for the
given model.}
}
\value{
The form of the value returned by \code{sig_regions} depends on the
  class of its argument. See the documentation of the particular methods for
  details of what is produced by that method.
}
\description{
\code{sig_regions} is a generic function for calculating the Johnson-Neyman
regions of significance for an interaction, the points at which the simple
effect of the categorical predictor changes from non-significant to
significant.
}
\examples{
# mtcars data
mtcars$am <- factor(mtcars$am)  # make 'am' categorical
model <- lm(mpg ~ wt * am, data=mtcars)
summary(model)  # significant interaction
sig_regions(model)
}
\seealso{
\code{\link{sig_regions.lm}}, \code{\link{simple_slopes}}
}

