% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{residuals.block_glm}
\alias{residuals.block_glm}
\title{Extract model residuals.}
\usage{
\method{residuals}{block_glm}(object, num = NULL, ...)
}
\arguments{
\item{object}{An object of class "\code{block_glm}", usually, a result of a
call to \code{\link{build_model}}.}

\item{num}{Numeric vector with the index of model(s) from which to return the
residuals.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The residuals of block(s) `num`, or if `num` is NULL, a list of
  residuals from all blocks.
}
\description{
\code{residuals} method for class "\code{block_glm}".
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
residuals(model1)  # returns both blocks 1 and 2

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
residuals(model2, num=2)  # returns second block
}
\seealso{
\code{\link{build_model}}, \code{residuals.block_glm_summary},
  \code{\link{fitted.block_glm}}, \code{coef.block_glm}
}

