% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_protein2RNA.R
\name{refseq_protein2RNA}
\alias{refseq_protein2RNA}
\title{Get the transcript accession from the protein accession}
\usage{
refseq_protein2RNA(protein)
}
\arguments{
\item{protein}{A character string of the protein id.}
}
\value{
A character vector containing the transcript ids that encode the \code{protein}.
}
\description{
\code{refseq_protein2RNA()} Returns the transcript accession from a single protein accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes XM_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
 # Get the transcript id from a single protein accession
 protein <- "XP_020244413"
 refseq_protein2RNA(protein)

\donttest{
 # Get the transcript ids from a set of protein accessions
 protein = c("XP_004487758", "XP_004488550")
 sapply(protein, function(x) refseq_protein2RNA(x), USE.NAMES = FALSE)}

}
\seealso{
\code{\link{refseq_RNA2protein}} to obtain the protein ids encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
