% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACE.R
\name{ACE}
\alias{ACE}
\title{Alternating Conditional Expectation (ACE) algorithm}
\usage{
ACE(
  y = "y",
  predictor = "~s(x)",
  restriction = "positive",
  eps = 0.01,
  itmax = 10,
  data = data,
  ...
)
}
\arguments{
\item{y}{A character defining the response variable.}

\item{predictor}{The regression predictor, following the mgcv package structure (see example below).}

\item{restriction}{Type of restriction to be imposed to the response variable,
"positive" for variance, and "correlation" for the correlation.}

\item{eps}{A number defining the allowed estimation error, default = 0.01.}

\item{itmax}{Maximum number of iterations of the algorithm, default = 10.}

\item{data}{A data frame containing the response, and predictor variables.}

\item{...}{Additional mgcv::gam() parameters to be modified by the user.}
}
\value{
This function returns a mgcv::gam() fit for a transformed response.
}
\description{
This function implements Alternating Conditional Expectation algorithm
(ACE, Hastie and Tibshirani, 1990). This is a bivRegr's inner function
for estimating variance, and correlation models.
}
\examples{
n <- 100
x <- runif(n,-1,1)
y <- x^2 + rnorm(n, sd=0.1)
df <- data.frame(y, x)
plot(df$x, df$y)
m1 <- ACE(y = "y", predictor = "~s(x)", restriction = "positive",
      eps = 0.01, itmax = 10, data = df)$fit
nw <- data.frame(x = seq(-1, 1, 0.1))
abline(h = 0, col = 2)
lines(exp(predict(m1,newdata = nw)) ~ nw$x, col = 3, lwd = 2)
legend("top",legend=c("ACE fit","Zero"),lty=1,lwd=2,col=c(3,2),bty="n")
}
\references{
Hastie, T. & Tibshirani, J. (1990) Generalized additive models.
CRC press. London.
}
