% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/World.R
\docType{methods}
\name{freeWorld}
\alias{freeWorld}
\alias{freeWorld,World-method}
\title{Free memory used by a librdf world object}
\usage{
freeWorld(.Object)

\S4method{freeWorld}{World}(.Object)
}
\arguments{
\item{.Object}{a World object}
}
\description{
Free memory used by a librdf world object
}
\details{
After this method is called, the World object is no longer usable and should
be deleted \code{"rm(world)"} and a new object created.
}
\examples{
world <- new("World")
# At this point we would perform some operations using the world object.
# When the world object is no longer needed, we can free the resources it has allocated.
result <- freeWorld(world)
rm(world)
}
