% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_egap}
\alias{part_egap}
\title{Calculate Efficiency Gap}
\usage{
part_egap(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object, tibble, or data frame containing other columns}

\item{dvote}{unqouted name of column in shp with total population}

\item{rvote}{unqouted name of column in shp with group population}
}
\value{
numeric vector
}
\description{
Calculate Efficiency Gap
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_egap(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_egap(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Nicholas O. Stephanopoulos. 2015.
Partisan Gerrymandering and the Efficiency Gap.
The University of Chicago Law Review, 82, Pp. 831-900.
}
\concept{partisan}
