% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_tau_gap}
\alias{part_tau_gap}
\title{Calculate Tau Gap}
\usage{
part_tau_gap(plans, shp, dvote, rvote, tau = 1)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{dvote}{unqouted name of column in shp with total population}

\item{rvote}{unqouted name of column in shp with group population}

\item{tau}{A non-negative numeric for calculating Tau Gap. Defaults to 1.}
}
\value{
numeric vector
}
\description{
Calculate Tau Gap
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_tau_gap(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_tau_gap(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Gregory S. Warrington. 2018. "Quantifying Gerrymandering Using the Vote Distribution."
Election Law Journal: Rules, Politics, and Policy. Pp. 39-57.http://doi.org/10.1089/elj.2017.0447
}
\concept{partisan}
