% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteArms.R
\name{deleteArms}
\alias{deleteArms}
\alias{deleteArms.redcapApiConnection}
\title{Delete Arms From a Project}
\usage{
deleteArms(rcon, arms, ...)

\method{deleteArms}{redcapApiConnection}(
  rcon,
  arms,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by 
\code{redcapConnection}.}

\item{arms}{\code{character}, a vector of arm numbers that will be 
deleted. May also be \code{integerish}.}

\item{...}{Additional arguments to pass to other methods.}

\item{refresh}{\code{logical(1)} If \code{TRUE}, the cached arms data will
be refreshed after the deletion.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
None.
}
\description{
Delete arms from a project.  This is a destructive action that
  will result in deletion of any events and data associated with the arm.
  Due to its destructive nature, it may only be performed on databases 
  in development status.  Data loss is non-reversible.
}
\section{REDCap API Documentation}{

This method allows you to delete Arms from a project. 
Notice: Because of this method's destructive nature, it is only 
available for use for projects in Development status. Additionally, 
please be aware that deleting an arm also automatically deletes all 
events that belong to that arm, and will also automatically delete 
any records/data that have been collected under that arm (this is 
non-reversible data loss).

NOTE: This only works for longitudinal projects.
}

\section{REDCap Version}{

At least 8.1.17+ (and likely some earlier versions)
}

\references{
Please refer to your institution's API documentation.
}
