% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{time_on_page}
\alias{time_on_page}
\title{Calculate time-on-page metrics}
\usage{
time_on_page(sessions, by_session = FALSE, median = FALSE, precision = 2)
}
\arguments{
\item{sessions}{a sessions dataset, presumably generated with
\code{\link{sessionise}}.}

\item{by_session}{Whether to generate time-on-page for the dataset overall (FALSE),
or on a per-session basis (TRUE). FALSE by default.}

\item{median}{whether to generate the median (TRUE) or mean (FALSE)
time-on-page. FALSE by default.}

\item{precision}{the number of decimal places to round the output to
- set to 2 by default.}
}
\value{
either a single numeric value, representing the mean/median time on page
for the overall dataset, or a data.frame of session IDs and numeric values if
\code{by_session} is TRUE.
}
\description{
\code{time_on_page} generates metrics around the mean (or median)
time-on-page - on an overall, per-user, or per-session basis.
}
\examples{
#Load and sessionise the dataset
data("session_dataset")
sessions <- sessionise(session_dataset, timestamp, uuid)

# Calculate overall time on page
top <- time_on_page(sessions)

# Calculate time-on-page on a per_session basis
per_session <- time_on_page(sessions, by_session = TRUE)

# Use median instead of mean
top_med <- time_on_page(sessions, median = TRUE)

}
\seealso{
\code{\link{sessionise}} for session reconstruction, and
\code{\link{session_length}}, \code{\link{session_count}} and
\code{\link{bounce_rate}} for other session-related metrics.
}

