% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{session_count}
\alias{session_count}
\title{Count the number of sessions in a sessionised dataset}
\usage{
session_count(sessions, user_id = NULL)
}
\arguments{
\item{sessions}{a dataset of sessions, presumably generated by
\code{\link{sessionise}}}

\item{user_id}{the column of \code{sessions} containing user IDs. If
NULL (the default), a single count of sessions for the entire dataset
will be generated. Otherwise, a data.frame of user IDs and the session
count for each user ID will be returned.}
}
\value{
either a single integer value or a data.frame (see above).
}
\description{
\code{link{session_count}} counts the number of sessions in a sessionised
dataset, producing either a count for the overall dataset or on a per-user
basis (see below).
}
\examples{
#Load and sessionise the dataset
data("session_dataset")
sessions <- sessionise(session_dataset, timestamp, uuid)

# Calculate overall bounce rate
count <- session_count(sessions)

# Calculate session count on a per-user basis
per_user <- session_count(sessions, user_id = uuid)

}

