% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{reconstruct_sessions}
\alias{reconstruct_sessions}
\title{split a series of timestamps (or a series of series) associated with UUIDs, into sessions}
\usage{
reconstruct_sessions(timestamps, threshold = 3600L)
}
\arguments{
\item{timestamps}{a list of vectors of second values. These can be extracted by converting
POSIXlt or POSIXct timestamps into numeric elements through a call to \code{\link{as.numeric}},
or with the assistance of \code{\link{to_seconds}}.}

\item{threshold}{the threshold, in seconds, for splitting out a new session. Set to 
3600 (one hour) by default.}
}
\value{
a list of vectors, each one representing a single session.
The returned list can be conveniently
passed into \code{\link{session_length}} or \code{\link{session_events}} for further analysis.
}
\description{
\code{reconstruct_sessions} splits timestamps associated with user events into "sessions",
enabling the simple calculation of various metrics such as session length or the number of events
within a session.
}
\examples{
#Take the inbuilt dataset and sessionise it
data("session_dataset")
session_dataset$timestamp <- to_seconds(x = session_dataset$timestamp, format = "\%Y\%m\%d\%H\%M\%S")
events_by_user <- split(session_dataset$timestamp, session_dataset$UUID)
sessions <- reconstruct_sessions(events_by_user)
}
\seealso{
\code{\link{session_length}} for calculating session length, \code{\link{bounce_rate}} for
calculating the bounce rate, and \code{\link{session_events}} for calculating the number of events in each session.
}

