% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recogito.R
\name{recogito}
\alias{recogito}
\title{Annotate text with tags and relations}
\usage{
recogito(
  inputId = "annotations",
  text,
  type = c("relations", "tags"),
  tags = c("Location", "Person", "Place", "Other"),
  mode = c("html", "pre"),
  annotations = "{}",
  width = NULL,
  height = NULL,
  elementId = NULL,
  dependencies = NULL
)
}
\arguments{
\item{inputId}{character string with the name to use where annotations will be put into}

\item{text}{character string with the text to annotate}

\item{type}{either 'relations' or 'tags' in order to label relations between tags or only plain tags}

\item{tags}{character vector of possible tags}

\item{mode}{either 'html' or 'pre'}

\item{annotations}{character string with a predefined set of annotations}

\item{width}{passed on to \code{\link[htmlwidgets]{createWidget}}}

\item{height}{passed on to \code{\link[htmlwidgets]{createWidget}}}

\item{elementId}{passed on to \code{\link[htmlwidgets]{createWidget}}}

\item{dependencies}{passed on to \code{\link[htmlwidgets]{createWidget}}}
}
\value{
An object of class htmlwidget as returned by \code{\link[htmlwidgets]{createWidget}}
}
\description{
Functionality to tag text with entities and relations between these
}
\examples{
txt <- "Josh went to the bakery in Brussels.\nWhat an adventure!"
x   <- recogito(inputId = "annotations", txt)
x
x   <- recogito(inputId = "annotations", txt, type = "tags",
                tags = c("LOCATION", "TIME", "PERSON"))
x
txt <- "Lorem ipsum dolor sit amet consectetur adipiscing elit Quisque tellus urna
  placerat in tortor ac imperdiet sollicitudin mi Integer vel dolor mollis feugiat
  sem eu porttitor elit Sed aliquam urna sed placerat euismod In risus sem ornare
  nec malesuada eu ornare quis dui Nunc finibus fermentum sollicitudin Fusce vel
  imperdiet mi ac faucibus leo Cras massa massa ultricies et justo vitae molestie
  auctor turpis Vestibulum euismod porta risus euismod dapibus Nullam facilisis
  ipsum sed est tempor et aliquam sapien auctor Aliquam velit ligula convallis a
  dui id varius bibendum quam Cras malesuada nec justo sed
  aliquet Fusce urna magna malesuada"
x   <- recogito(inputId = "annotations", txt)
x
x   <- recogito(inputId = "annotations", txt, type = "tags",
                tags = c("LOCATION", "TIME", "PERSON", "OTHER"))
x

##
## Color the tags by specifying CSS - they should have .tag-{TAGLABEL}
##
library(htmltools)
cat(readLines(system.file(package = "recogito", "examples", "example.css")), sep = "\n")
tagsetcss <- htmlDependency(name = "mytagset", version = "1.0",
                            src = system.file(package = "recogito", "examples"),
                            stylesheet = "example.css")
x   <- recogito(inputId = "annotations", txt,
                tags = c("LOCATION", "TIME", "PERSON", "OTHER"),
                dependencies = tagsetcss)
x
}
\seealso{
\code{\link{recogito-shiny}}
}
