% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_simsum.R
\name{score_simsum}
\alias{score_simsum}
\title{Score pairs by summing the similarity vectors}
\usage{
score_simsum(pairs, var = "simsum", by, add = TRUE, na_value = 0, ...)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{var}{a character vector of length 1 with the name of the variable that
will be created.}

\item{by}{a character vector with the column names from \code{pairs} that
should be summed. When missing the \code{by} attribute from \code{pairs}
is used.}

\item{add}{add the variable to the \code{pairs} object and return the 
\code{pairs} object. Otherwise, return a vector with the scores.}

\item{na_value}{the value to use for missing values}

\item{...}{passed on to other methods.}
}
\value{
When \code{add = TRUE} the original \code{pairs} object is returned with the 
column given by \code{var} added to it. Otherwise a vector with scores is 
returned.
}
\description{
Score pairs by summing the similarity vectors
}
\details{
The scores are calculated by summing the columns given by \code{by}. Missing
values are counted as zeros.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
pairs <- score_simsum(pairs)
 
}
