% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{summary.lgcpReal}
\alias{summary.lgcpReal}
\title{Summarise lgcp output}
\usage{
\method{summary}{lgcpReal}(object, linear = TRUE, plot = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{object}{An \code{lgcpReal} object from a call to \code{lgcp}}

\item{linear}{A logical value indicating whether results should be reported on linear or exponential scales}

\item{plot}{A logical value indicating whether to produce plots of the prior and posterior distributions of model parameters}

\item{verbose}{A logical value indicating whether to print running time and chains}

\item{...}{...}
}
\value{
A table with posterior mean, SD, and quantiles of posterior and prior distributions
}
\description{
Summarise output from a call to \code{lgcp}
}
\examples{
\donttest{
data(dat,square,square_pop)
lg1 <- lgcp(data=dat,
            pop.var = c("popdens"),
            boundary=square,
            covariates=square_pop,
            cellwidth=0.1,
            laglength = 7,
            mala.pars=c(200,100,1),
            nchains=2)
summary(lg1,plot=FALSE)
}
}
