% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_lgcp_dat}
\alias{plot_lgcp_dat}
\title{Extract data from an lgcpReal object}
\usage{
plot_lgcp_dat(
  samps,
  grid.data,
  lg,
  nchains,
  idx.mapping = NULL,
  cellwidth = 0.005,
  covariates,
  plotlag = 0,
  data.out = FALSE
)
}
\arguments{
\item{samps}{MCMC samples extracted from lgcpReal object}

\item{grid.data}{Grid used for sampling and plotting}

\item{lg}{lgcpReal model fit}

\item{nchains}{Number of MCMC chains in model fit}

\item{idx.mapping}{Matrix specifying plot order of grid cells}

\item{cellwidth}{Cellwidth of the grid}

\item{covariates}{SpatialPolygonsDataFrame with the original covariate data}

\item{plotlag}{Laglength for the plot}

\item{data.out}{Logical indicating whether to return data frame with only
plotting data (FALSE) or a list containing each predicted model subcomponent (TRUE)}
}
\value{
A data.frame with model predictions across the computation grid used in the plotting
functions in this package.
}
\description{
Helper function to create plotting data from an lgcpReal object
}
