% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_rds}
\alias{write_rds}
\title{Write a single R object to file}
\usage{
write_rds(x, path, compress = c("none", "gz", "bz2", "xz"), ...)
}
\arguments{
\item{x}{R object to write to serialise.}

\item{path}{Path to write to.}

\item{compress}{Compression method to use: "none", "gz" ,"bz", or "xz".}

\item{...}{Additional arguments to connection function. For example, control
the space-time trade-off of different compression methods with
\code{compression}. See \code{\link{connections}} for more details.}
}
\value{
The input \code{x}, invisibly.
}
\description{
Consistent wrapper around \code{\link{saveRDS}}. \code{write_rds} does not
compress by default as space is generally cheaper than time.
}
\examples{
\dontrun{
write_rds(mtcars, "mtcars.rds")
write_rds(mtcars, "compressed_mtc.rds", "xz", compression = 9L)
}
}

