% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/count_fields.R
\name{count_fields}
\alias{count_fields}
\title{Count the number of fields in each line of a file.}
\usage{
count_fields(file, tokenizer, skip = 0)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{tokenizer}{A tokenizer that specifies how to break the \code{file}
up into fields, e.g., \code{\link{tokenizer_csv}},
\code{\link{tokenizer_fwf}}}

\item{skip}{Number of lines to skip before reading data.}
}
\description{
This is useful for diagnosing problems with functions that fail
to parse correctly.
}
\examples{
count_fields(system.file("extdata/mtcars.csv", package = "readr"),
 tokenizer_csv())
}

