% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh3d.R
\name{tinyobj2shapelist3d}
\alias{tinyobj2shapelist3d}
\title{Convert the raw tinyobjloader shapes/materials list into an rgl shapelist3d}
\usage{
tinyobj2shapelist3d(x)
}
\arguments{
\item{x}{A raw tinyobjloader shapes/materials list}
}
\value{
a list of class \code{shapelist3d} containing a \code{mesh3d} for
  each object or group element in the original OBJ file.
}
\description{
Convert the raw tinyobjloader shapes/materials list into an rgl shapelist3d
}
\details{
Not all materials settings can be processed at the moment. In
  particular only the following are used: \itemize{

  \item \code{diffuse} -> mapped onto rgl material \code{color} field

  \item \code{ambient}

  \item \code{specular}

  \item \code{emission}

  }
}
\examples{
cube=read.obj(system.file("obj/cube.wavefront", package = "readobj"))
if(require("rgl")){
  cubesl=tinyobj2shapelist3d(cube)
  shade3d(cubesl)
}
}
\seealso{
\code{\link{read.obj}}, \code{\link[rgl]{mesh3d}},
  \code{\link[rgl]{shapelist3d}}, \code{\link[rgl]{rgl.material}}
}
