% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sormas-helpers.R
\name{sormas_get_diseases}
\alias{sormas_get_diseases}
\title{Get the list of disease names from a SORMAS instance}
\usage{
sormas_get_diseases(login)
}
\arguments{
\item{login}{A list with the user's authentication details}
}
\value{
A vector of the list of disease names in a SORMAS instance
}
\description{
Get the list of disease names from a SORMAS instance
}
\examples{
\dontrun{
  # establish the connection to the SORMAS system
  sormas_login <- login(
    type = "sormas",
    from = "https://demo.sormas.org/sormas-rest",
    user_name = "SurvSup",
    password = "Lk5R7JXeZSEc"
  )
  disease_names <- sormas_get_diseases(
    login = sormas_login
  )
}

}
