% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{getPopulation}
\alias{getPopulation}
\alias{getPopulation.genalex}
\title{Return genotypes for specified populations}
\usage{
\method{getPopulation}{genalex}(x, pop, ...)
}
\arguments{
\item{x}{An annotated data frame of class \code{'genalex'}}

\item{pop}{The names of one or more populations for which \code{x}
contains genotypes}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
An object of class \code{'genalex'} containing genotype data
from \code{x} for populations specified in \code{code}.  Attributes
are re-calculated so that the return value is a valid object of class
\code{'genalex'}, and the \code{"data.file.name"} attribute is updated
to reflect the action of this function.
}
\description{
Return genotype data for specified populations from an object of class
\code{'genalex'}, in an object of class \code{'genalex'}.
}
\examples{
data(Qagr_pericarp_genotypes)
nm <- getPopulation(Qagr_pericarp_genotypes, "L0031")
nm
}
\author{
Douglas G. Scofield
}

