% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{extra}
\alias{extra}
\alias{extra<-}
\alias{extra<-.genalex}
\title{Return or set the extra data columns of an object of class \code{'genalex'}}
\usage{
extra(x, ...)
extra(x) <- value
}
\arguments{
\item{x}{An annotated data frame of class \code{'genalex'}
or of class \code{'loci'} converted from class \code{'genalex'}
with \code{\link{as.loci}}}

\item{value}{When setting extra columns, a data frame or object
that can be coerced to a data frame.  This is done using
\code{stringsAsFactors = FALSE}.  \code{value} must have the
same number of rows as \code{x}.}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
A data frame containing extra columns from \code{x}, or
\code{NULL} if extra columns do not exist.  If setting, an object
of class \code{'genalex'} with its \code{"extra.columns"} attribute
set to \code{value}, after its rownames are adjusted as described
above.
}
\description{
Return or set the extra data columns of an object of class
\code{'genalex'}.  When getting extra data columns, if there are
none, \code{NULL} is returned.  When setting, this is more than a
shortcut for \code{attr(x, "extra.columns") <- value}.  It checks
that both \code{value} and \code{x} have the same number of rows,
generating an error if not, and it sets the row names of
\code{value} to be equal to the sample names in \code{x} before
assigning \code{value} to the \code{"extra.columns"} attribute.
}
\examples{
data(Qagr_adult_genotypes)
x1 <- attr(Qagr_adult_genotypes, "extra.columns")
x2 <- extra(Qagr_adult_genotypes)
## there are no extra columns, so both should be NULL
if (! isTRUE(all.equal(x1, x2)) || ! is.null(x1) || ! is.null(x2))
    cat("something went wrong")
}
\author{
Douglas G. Scofield
}

