% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_bars.R
\name{data_bars}
\alias{data_bars}
\title{Add horizontal bars to rows in a column}
\usage{
data_bars(data, colors = "#1e90ff", background = "white", number_fmt = NULL)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{colors}{A single color or a vector of colors.
Colors should be given in order from low values to high values.
Can use R's built-in colors or other color packages.}

\item{background}{Optionally assign a color to use as the background for cells.
Default is set to white.}

\item{number_fmt}{Optionally format numbers using formats from the scales package.
Default is set to NULL.}
}
\value{
a function that applies data bars
    to a column of numeric values.
}
\description{
The `data_bars()` function conditionally adds a horizontal bar to each row of a column.
    The length of the bars are relative to the value of the row in relation to other values within the same column.
    It should be placed within the cell argument in reactable::colDef.
}
\examples{
library(reactable)
data <- MASS::Cars93[20:49, c("Make", "MPG.city", "MPG.highway")]

## Horizontal bars with lengths relative to cell value
reactable(data,
columns = list(
MPG.city = colDef(
name = "MPG (city)",
align = "left",
cell = data_bars(data, "dodgerblue"))))

## Add background color
reactable(data,
columns = list(
MPG.city = colDef(
name = "MPG (city)",
align = "left",
cell = data_bars(data, "dodgerblue", "grey"))))

## Conditionally color data bars based on their relative values
## by supplying more than one color
## and apply across all numeric columns using reactable::defaultColDef
reactable(data,
pagination = FALSE,
defaultSortOrder = "desc",
defaultSorted = "MPG.city",
defaultColDef = colDef(
cell = data_bars(data,
colors = c("firebrick1","gold","limegreen"))))

## Use number_fmt to format numbers using the scales package
car_prices <- MASS::Cars93[20:49, c("Make", "Price")]

reactable(car_prices,
defaultColDef = colDef(cell = data_bars(car_prices,
number_fmt = scales::dollar_format(accuracy = 0.1))))

}
