% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBorders.R
\docType{data}
\name{DEU}
\alias{DEU}
\title{Map of German states (Bundeslaender) from GADM through the \code{raster} package}
\format{
Formal class 'SpatialPolygons' (package "sp") with 4 slots
}
\description{
Map of German states (Bundeslaender) from GADM through the \code{raster} package
}
\details{
Use directly with:\cr
\code{load(system.file("extdata/DEU.rda", package="rdwd"))}\cr\cr
Obtained with the code: \cr\preformatted{url <- "https://gisco-services.ec.europa.eu/distribution/v2/nuts/shp/NUTS_RG_03M_2021_4326_LEVL_1.shp.zip"
tf <- tempfile(fileext=".zip")
download.file(url, tf) # 0.9 MB
unzip(tf, exdir="misc/vign") ; rm(url, tf)

DEU <- raster::shapefile("misc/vign/NUTS_RG_03M_2021_4326_LEVL_1.shp")
DEU <- DEU[DEU$CNTR_CODE=="DE","NUTS_NAME"]
raster::plot(DEU) ; axis(1, line=-1) ; axis(2, line=-1)

save(DEU,        file="inst/extdata/DEU.rda", version=2)
tools::resaveRdaFiles("inst/extdata/DEU.rda", version=2)
}
}
\seealso{
\code{\link{addBorders}}, \code{\link{EUR}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2018
}
\keyword{datasets}
