% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexFTP.R
\name{indexFTP}
\alias{indexFTP}
\title{Create a recursive index of the DWD CDC FTP Server}
\usage{
indexFTP(folder = "currentfindex", base = dwdbase,
  is.file.if.has.dot = TRUE, sleep = 0, dir = "DWDdata",
  filename = folder[1], overwrite = FALSE, quiet = FALSE,
  progbar = !quiet, verbose = FALSE)
}
\arguments{
\item{folder}{Folder(s) to be indexed recursively, e.g. "/hourly/wind/".
Use \code{folder=""} to search at the location of \code{base} itself.
If code{folder} is "currentfindex" (the default) and \code{base} 
is the default, code{folder} is changed to all folders in current 
\code{\link{fileIndex}}: \code{unique(dirname(fileIndex$path))}.
Leading slashes will be removed. DEFAULT: "currentfindex"}

\item{base}{Main directory of FTP server, defaulting to DWD observed climatic records.
Trailing slashes will be removed. DEFAULT: \code{\link{dwdbase}}:
\url{ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate}}

\item{is.file.if.has.dot}{Logical: if some of the input paths contain a dot, 
treat those as files, i.e. do not try to read those as if they
were a folder. Only set this to FALSE if you know what you're doing.
DEFAULT: TRUE}

\item{sleep}{If not 0, a random number of seconds between 0 and \code{sleep}
is passed to \code{\link{Sys.sleep}} after each read folder
to avoid getting kicked off the FTP-Server. DEFAULT: 0}

\item{dir}{Writeable directory name where to save the downloaded file.
Created if not existent.
DEFAULT: "DWDdata" at current \code{\link{getwd}()}}

\item{filename}{Character: Part of output filename. "INDEX_of_DWD_" is prepended,
"/" replaced with "_", ".txt" appended. DEFAULT: folder[1]}

\item{overwrite}{Logical: Overwrite existing file? If not, "_n" is added to the
filename, see \code{berryFunctions::\link[berryFunctions]{newFilename}}.
DEFAULT: FALSE}

\item{quiet}{Suppress progbars and message about directory/files? DEFAULT: FALSE}

\item{progbar}{Logical: present a progress bar in each level?
Only works if the R package pbapply is available. DEFAULT: TRUE}

\item{verbose}{Logical: write a lot of messages from \code{RCurl::\link[RCurl]{getURL}}?
DEFAULT: FALSE (usually, you dont need all the curl information)}
}
\value{
currently a vector with file paths (output may change in the future)
}
\description{
Create a list of all the files (in subfolders) at the Climate Data Center (CDC)
FTP-Server from the German Weather Service (DWD, Deutscher WetterDienst) at
\url{ftp://ftp-cdc.dwd.de/pub/CDC/observations_germany/climate}.\cr\cr
The R package \code{RCurl} must be available to do this.
If \code{RCurl::\link[RCurl]{getURL}} fails, usually because bot access is
detected and denied, there will still be an output which you can pass in a
second run via \code{folder} to extract the remaining dirs.
You might want to wait a bit and set \code{sleep} to a higher value in that case. 
Here's an example:\cr
\code{gridindex <- indexFTP("grids_germany","ftp://ftp-cdc.dwd.de/pub/CDC")}\cr
\code{gridindex <- indexFTP(gridindex,"ftp://ftp-cdc.dwd.de/pub/CDC", sleep=1)}\cr
}
\details{
It's not suggested to run this for all folders, as it can take quite some time
and you may get kicked off the FTP-Server. This package contains an index
of the climatic observations at weather stations: \code{View(rdwd:::\link{fileIndex})}
If it is out of date, please let me know!
}
\examples{
\dontrun{ ## Needs internet connection
sol <- indexFTP(folder="/daily/solar", dir=tempdir())
head(sol)

# mon <- indexFTP(folder="/monthly/kl", dir=tempdir(), verbose=TRUE)
}

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2016
}
\keyword{file}
