% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdmcplot.R
\name{rdmcplot}
\alias{rdmcplot}
\title{RD plots with multiple cutoffs.}
\usage{
rdmcplot(Y, X, C, pvec = NULL, hmat = NULL, nbinsmat = NULL,
  binselectvec = NULL, scalevec = NULL, kernelvec = NULL,
  weightsvec = NULL, supportmat = NULL, covsvec = NULL,
  nobins = FALSE, nopoly = FALSE, nodraw = FALSE)
}
\arguments{
\item{Y}{outcome variable.}

\item{X}{running variable.}

\item{C}{cutoff variable.}

\item{pvec}{vector of cutoff-specific polynomial orders. See \code{rdplot()} for details.}

\item{hmat}{matrix of cutoff-specific bandwidths. See \code{rdplot()} for details.}

\item{nbinsmat}{matrix of cutoff-specific number of bins. See \code{rdplot()} for details.}

\item{binselectvec}{vector of cutoff-specific bins selection method. See \code{rdplot()} for details.}

\item{scalevec}{vector of cutoff-specific scale factors. See \code{rdplot()} for details.}

\item{kernelvec}{vector of cutoff-specific kernels. See \code{rdplot()} for details.}

\item{weightsvec}{vector of cutoff-specific weights. See \code{rdplot()} for details.}

\item{supportmat}{matrix of cutoff-specific support conditions. See \code{rdplot()} for details..}

\item{covsvec}{vector of cutoff-specific covariates. See \code{rdplot()} for details.}

\item{nobins}{omits bins plot.}

\item{nopoly}{omits polynomial curve plot.}

\item{nodraw}{omits plot.}
}
\value{
\item{clist}{list of cutoffs}
\item{cnum}{number of cutoffs}
\item{X0}{matrix of X values for control units}
\item{X1}{matrix of X values for treated units}
\item{Yhat0}{estimated polynomial for control units}
\item{Yhat1}{estimated polynomial for treated units}
\item{Xmean}{bin average of X values}
\item{Ymean}{bin average for Y values}
}
\description{
\code{rdmc()} RD plots with multiple cutoffs.
}
\examples{
# Toy dataset
X <- runif(1000,0,100)
C <- c(rep(33,500),rep(66,500))
Y <- (1 + X + (X>=C))*(C==33)+(.5 + .5*X + .8*(X>=C))*(C==66) + rnorm(1000)
# rdmcplot with standard syntax
tmp <- rdmcplot(Y,X,C)


}
\references{
M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2019). \href{https://sites.google.com/site/rdpackages/rdmulti/Cattaneo-Titiunik-VazquezBare_2019_rdmulti.pdf}{Analysis of Regression Discontinuity Designs with Multiple Cutoffs or Multiple Scores}. \emph{Working paper}.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
