% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qDZ.R
\name{qDZ}
\alias{qDZ}
\title{Similarity-sensitive diversity}
\usage{
qDZ(meta, qs)
}
\arguments{
\item{meta}{object of class \code{metacommunity}.}

\item{qs}{\code{vector} of \emph{q} values.}
}
\value{
Returns an object of class \code{matrix}, with rows as \code{qs} 
columns as subcommunities, and elements containing diversity values.
}
\description{
Calculates the similarity-sensitive diversity of a series of columns
representing independent populations, for a series of orders repesented as
a vector of \code{qs}.
}
\examples{
pop <- sample(1:50, 5)

# Create similarity matrix
Z <- diag(1, length(pop))
Z[Z==0] <- 0.4

dat <- metacommunity(pop, Z)

# Calculate similarity-sensitive diversity of order 0 (species richness)
qDZ(dat, 0)

}
