% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastService.R
\name{dfp_getDeliveryForecastByIds}
\alias{dfp_getDeliveryForecastByIds}
\title{getDeliveryForecastByIds}
\usage{
dfp_getDeliveryForecastByIds(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getDeliveryForecastByIdsResponse
}
\description{
Gets the delivery forecast for a list of existing LineItem objects in a single delivery simulation. A delivery forecast reports the number of units that will be delivered to each line item given the line item goals and contentions from other line items. Gets the delivery forecast for a list of existing LineItem objects in a single delivery simulation. A delivery forecast reports the number of units that will be delivered to each line item given the line item goals and contentions from other line items. @param lineItemIds the IDs of line items to be forecasted for delivery @param forecastOptions options controlling the forecast Gets the delivery forecast for a list of existing LineItem objects in a single delivery simulation. A delivery forecast reports the number of units that will be delivered to each line item given the line item goals and contentions from other line items. @param lineItemIds the IDs of line items to be forecasted for delivery @param forecastOptions options controlling the forecast
}
\examples{
\dontrun{
filter <- "WHERE Status='DELIVERING' LIMIT 1"
one_li <- dfp_getLineItemsByStatement(list(filterStatement=list(query=filter)))[[1]]

# not specifying forecastOptions brings up NotNullError.ARG2_NULL, so send, but keep null
request_data <- list(lineItemIds=one_li$id,
                     forecastOptions=list(ignoredLineItemIds=NULL))
result <- dfp_getDeliveryForecastByIds(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ForecastService#getDeliveryForecastByIds}{Google Documentation for getDeliveryForecastByIds}
}
