% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivityGroupService.R
\name{dfp_createActivityGroups}
\alias{dfp_createActivityGroups}
\title{ActivityGroupService}
\usage{
dfp_createActivityGroups(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createActivityGroupsResponse
}
\description{
Provides methods for creating, updating and retrieving ActivityGroup
objects.
An activity group contains Activity objects. Activities have a
many-to-one relationship with activity groups, meaning each activity can
belong to only one activity group, but activity groups can have multiple
activities. An activity group can be used to manage the activities it
contains.
}
\details{
createActivityGroups

Creates a new ActivityGroup objects.
}
\examples{
\dontrun{
 res <- dfp_createActivityGroups(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ActivityGroupService#createActivityGroups}{Google Documentation for createActivityGroups}
}
