% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfp_utils.R
\name{execute_soap_request}
\alias{execute_soap_request}
\title{Transmit and Receive API SOAP Calls}
\usage{
execute_soap_request(request_body, service = NULL,
  network_code = getOption("rdfp.network_code"),
  application_name = getOption("rdfp.application_name"),
  version = getOption("rdfp.version"), verbose = FALSE)
}
\arguments{
\item{request_body}{a character string of XML with service name
as an attribute}

\item{service}{a character string matching one of the API
services}

\item{network_code}{a character string matching the code 
associated with the ad serving network}

\item{application_name}{a character string naming your
application so that it can be identified in API calls}

\item{version}{a character string indicating the version of the DFP API 
that is to be used in the SOAP request}

\item{verbose}{a logical indicating whether to print the POSTed XML}
}
\value{
a XML document if no error was returned
}
\description{
Pull together SOAP Header and Body and 
make call to the appropriate API service, then 
parse the response.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
