% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuggestedAdUnitService.R
\name{dfp_getSuggestedAdUnitsByStatement}
\alias{dfp_getSuggestedAdUnitsByStatement}
\title{SuggestedAdUnitService}
\usage{
dfp_getSuggestedAdUnitsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getSuggestedAdUnitsByStatementResponse
}
\description{
This service provides operations for retrieving and approving
SuggestedAdUnit objects.
Publishers may create ad tags that lack a
corresponding ad unit defined in DFP, in order to gather information about
potential ads without needing to create dummy ad units and make them
available for targeting in line items. Any undefined ad unit to receive
more than ten serving requests in the past week is treated as a 'suggested
ad unit'. These can be queried by the client and selectively approved.
Approval causes a new ad unit to be created based on the suggested ad unit.
Unapproved suggested ad units cease to exist whenever their corresponding
ad tag has been served fewer than ten times in the past seven days.
This
service is only available to Premium publishers. Before use, suggested ad
units must be enabled for the client's network. This can be done in the UI:
in the Inventory tab, click "Network settings" in the left-hand panel, then
enable the checkbox "Get suggestions for new ad units." If suggested ad
units are not enabled, then #getSuggestedAdUnitsByStatement will always
return an empty page.
}
\details{
getSuggestedAdUnitsByStatement

Gets a SuggestedAdUnitPage of SuggestedAdUnit objects that satisfy the filter query. There is a system-enforced limit of 1000 on the number of suggested ad units that are suggested at any one time.  <strong>Note:</strong> After API version 201311, the id field will only be numerical. 
\itemize{
  \item{id}
  \item{numRequests}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getSuggestedAdUnitsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/SuggestedAdUnitService#getSuggestedAdUnitsByStatement}{Google Documentation for getSuggestedAdUnitsByStatement}
}
