% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductPackageService.R
\name{dfp_createProductPackages}
\alias{dfp_createProductPackages}
\title{ProductPackageService}
\usage{
dfp_createProductPackages(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createProductPackagesResponse
}
\description{
Provides methods for updating and retrieving ProductPackage objects.
A
ProductPackage represents a group of products which will be sold together.
}
\details{
To use this service, you need to have the new sales management solution
enabled on your network. If you do not see a "Sales" tab in
\href{https://www.google.com/dfp}{DoubleClick for Publishers (DFP)}, you
will not be able to use this service.

createProductPackages

Creates new ProductPackage objects.
}
\examples{
\dontrun{
 res <- dfp_createProductPackages(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/ProductPackageService#createProductPackages}{Google Documentation for createProductPackages}
}
