% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Action.R
\docType{class}
\name{Action}
\alias{Action}
\title{An action in a decision tree}
\description{
R6 class representing an action (choice) edge.
}
\details{
A specialism of class \code{Arrow} which is used in a decision tree
to represent an edge whose source node is a \code{DecisionNode}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Edge]{rdecision::Edge}} -> \code{\link[rdecision:Arrow]{rdecision::Arrow}} -> \code{Action}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Action-new}{\code{Action$new()}}
\item \href{#method-Action-modvars}{\code{Action$modvars()}}
\item \href{#method-Action-p}{\code{Action$p()}}
\item \href{#method-Action-cost}{\code{Action$cost()}}
\item \href{#method-Action-benefit}{\code{Action$benefit()}}
\item \href{#method-Action-clone}{\code{Action$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="endpoints"><a href='../../rdecision/html/Edge.html#method-Edge-endpoints'><code>rdecision::Edge$endpoints()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="is_same_edge"><a href='../../rdecision/html/Edge.html#method-Edge-is_same_edge'><code>rdecision::Edge$is_same_edge()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="label"><a href='../../rdecision/html/Edge.html#method-Edge-label'><code>rdecision::Edge$label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="source"><a href='../../rdecision/html/Arrow.html#method-Arrow-source'><code>rdecision::Arrow$source()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="target"><a href='../../rdecision/html/Arrow.html#method-Arrow-target'><code>rdecision::Arrow$target()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Action-new"></a>}}
\if{latex}{\out{\hypertarget{method-Action-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \code{Action}. Optionally, a cost and a benefit 
may 
be associated with traversing the edge. A \dfn{pay-off} (benefit minus 
cost)  is sometimes used in edges of decision trees; the parametrization
used here is more general.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$new(source, target, label, cost = 0, benefit = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{Decision node from which the arrow leaves.}

\item{\code{target}}{Node to which the arrow points.}

\item{\code{label}}{Character string containing the arrow label. This
must be defined for an action because the label is used in
tabulation of strategies. It is recommended to choose labels that are
brief and not punctuated with spaces, dots or underscores.}

\item{\code{cost}}{Cost associated with traversal of this edge.}

\item{\code{benefit}}{Benefit associated with traversal of the edge.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Action} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Action-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-Action-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables of type \code{ModVar} that have been 
specified
as values associated with this \code{Action}. Includes operands of these
\code{ModVar}s, if they are expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$modvars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Action-p"></a>}}
\if{latex}{\out{\hypertarget{method-Action-p}{}}}
\subsection{Method \code{p()}}{
Return the current value of the edge probability, i.e. the conditional
probability of traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$p()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric value equal to 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Action-cost"></a>}}
\if{latex}{\out{\hypertarget{method-Action-cost}{}}}
\subsection{Method \code{cost()}}{
Return the cost associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Cost.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Action-benefit"></a>}}
\if{latex}{\out{\hypertarget{method-Action-benefit}{}}}
\subsection{Method \code{benefit()}}{
Return the benefit associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$benefit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Benefit.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Action-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Action-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Action$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
