% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_ik12.R
\name{bw_ik12}
\alias{bw_ik12}
\title{Imbens-Kalyanaraman 2012 Optimal Bandwidth Calculation}
\usage{
bw_ik12(X, Y, cutpoint = NULL, verbose = FALSE, kernel = "triangular")
}
\arguments{
\item{X}{A numeric vector containing the running variable.}

\item{Y}{A numeric vector containing the outcome variable.}

\item{cutpoint}{A numeric value containing the cutpoint at which assignment to the treatment is determined. The default is 0.}

\item{verbose}{A logical value indicating whether to print more information to the terminal.
The default is \code{FALSE}.}

\item{kernel}{A string indicating which kernel to use. Options are \code{"triangular"} 
(default and recommended), \code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, and \code{"cosine"}.}
}
\value{
\code{ik_bw12} returns a numeric value specifying the optimal bandwidth.
}
\description{
\code{bw_ik12} calculates the Imbens-Kalyanaraman (2012) optimal bandwidth
for local linear regression in regression discontinuity designs.
It is based on a function in the "rddtools" package. 
This is an internal function and is typically not directly invoked by the user. 
It can be accessed using the triple colon, as in rddapp:::bw_ik12().
}
\references{
Imbens, G., Kalyanaraman, K. (2012). 
  Optimal bandwidth choice for the regression discontinuity estimator. 
  The Review of Economic Studies, 79(3), 933-959.
  \url{https://academic.oup.com/restud/article/79/3/933/1533189}.

Stigler, M. and B. Quast, B (2016). rddtools: A toolbox for regression discontinuity in R.
}
